﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VeteransAffairs.Registries.BusinessAHOBPR;
using System.Reflection;


namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public class AHOBPREmailTemplateManager : AHOBPRBaseBO
    {
        private AHOBPRLinqDataContext db = GetDataContext();
        private const string templatesDefaultSort = @"TEMPLATE_ID";
        private AHOBPRShared _sharedManager = new AHOBPRShared();

        /// <summary>
        /// Variable to hold the total count of a query before the paging.
        /// </summary>
        private int _totalCount;
        private int _totalCountForAdvancedUsers = 0;
        private int _totalCountByUser = 0;

        public class DictionaryDTO
        {
            public int Key { get; set; }
            public string Value { get; set; }
        }


        public EMAIL_TEMPLATE GetById(int templateId)
        {
            EMAIL_TEMPLATE result;
            using (AHOBPRLinqDataContext db = GetDataContext())
            {
                result = (from list in db.EMAIL_TEMPLATEs
                          where (list.TEMPLATE_ID == templateId)
                          select list).FirstOrDefault();
            }

            return result;

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="title"></param>
        /// <returns></returns>
        public bool TemplateTitleExists(string title, int templateId)
        {
            bool exists = false;
            using (AHOBPRLinqDataContext db = GetDataContext())
            {
                string existingTitle = (from e in db.EMAIL_TEMPLATEs
                                        where e.TITLE == title && e.TEMPLATE_ID != templateId
                                        select e.TITLE).FirstOrDefault();
                exists = (!string.IsNullOrEmpty(existingTitle));

            }
            return exists;
        }

        /// <summary>
        /// Get message template ID by Title
        /// </summary>
        /// <param name="title"></param>
        /// <returns></returns>
        public int GetTemplateIdByTitle(string title)
        {
            int id = 0;
            using (AHOBPRLinqDataContext db = GetDataContext())
            {
                EMAIL_TEMPLATE template = (from e in db.EMAIL_TEMPLATEs
                                           where e.TITLE == title
                                           select e).FirstOrDefault();
                if (template != null)
                {
                    id = template.TEMPLATE_ID;
                }
            }
            return id;
        }


        /// <summary>
        /// Method to return only the Title (by using the TemplateId).
        /// </summary>
        /// <param name="templateId"></param>
        /// <returns>Title of a email template.</returns>
        public string GetTitleByTemplateId(int templateId)
        {
            string results;
            using (AHOBPRLinqDataContext db = GetDataContext())
            {
                results = (from list in db.EMAIL_TEMPLATEs
                           where (list.TEMPLATE_ID == templateId)
                           select list.TITLE).FirstOrDefault();
            }

            return results;

        }

        /// <summary>
        /// Method to create a IDictionary(int, string) using Template ID and Title {Email Templates}.
        /// </summary>
        /// <returns></returns>
        public IDictionary<int, string> GetEmailTemplateForDropDown()
        {
            IDictionary<int, string> results;

            using (AHOBPRLinqDataContext db = GetDataContext())
            {
                results = (from list in db.EMAIL_TEMPLATEs
                           select new DictionaryDTO
                           {
                               Key = list.TEMPLATE_ID,
                               Value = list.TITLE
                           })
                    .OrderBy(ws => ws.Key)
                    .ToDictionary(ws => ws.Key, ws => ws.Value);
            }

            return results;
        }

 
        public int SaveOrUpdate(EMAIL_TEMPLATE emailTemplate)
        {
            int result = 0;
            using (AHOBPRLinqDataContext db = GetDataContext())
            {
                try
                {
                    EMAIL_TEMPLATE emailTemplateToInsertOrUpdate = db.EMAIL_TEMPLATEs.FirstOrDefault(em => em.TEMPLATE_ID == emailTemplate.TEMPLATE_ID);

                    if (emailTemplateToInsertOrUpdate != null) //existing
                    {
                        emailTemplateToInsertOrUpdate.TITLE = emailTemplate.TITLE;
                        emailTemplateToInsertOrUpdate.SUBJECT = emailTemplate.SUBJECT;
                        emailTemplateToInsertOrUpdate.BODY = emailTemplate.BODY;
                        emailTemplateToInsertOrUpdate.ACTIVE = emailTemplate.ACTIVE;
                        emailTemplateToInsertOrUpdate.UPDATED = emailTemplate.UPDATED;
                        emailTemplateToInsertOrUpdate.UPDATEDBY = emailTemplate.UPDATEDBY;
                        emailTemplateToInsertOrUpdate.EMAIL = emailTemplate.EMAIL;
                        emailTemplateToInsertOrUpdate.NOTIFICATION = emailTemplate.NOTIFICATION;
                        emailTemplateToInsertOrUpdate.SALUTATION = emailTemplate.SALUTATION;
                        emailTemplateToInsertOrUpdate.CONTACT_INFO = emailTemplate.CONTACT_INFO;
                        emailTemplateToInsertOrUpdate.ADVANCED_USER_FLAG = emailTemplate.ADVANCED_USER_FLAG;
                        emailTemplateToInsertOrUpdate.CREATEDBY_ADVANCED_USER_FLAG = emailTemplate.CREATEDBY_ADVANCED_USER_FLAG;
                    }
                    else //New
                    {
                        emailTemplateToInsertOrUpdate = emailTemplate;
                        db.EMAIL_TEMPLATEs.InsertOnSubmit(emailTemplate);
                    }

                    db.SubmitChanges();
                    result = emailTemplateToInsertOrUpdate.TEMPLATE_ID;
                }
                catch (Exception ex)
                {
                    _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                }
            }

            return result;
        }

        public IList<EMAIL_TEMPLATE> GetAll(string SortExpression, int maximumRows, int startRowIndex, bool includeTemplatesCreatedByAdvancedUsers)
        {
            if (string.IsNullOrEmpty(SortExpression))
            {
                SortExpression = templatesDefaultSort;
            }

            var results = from e in db.EMAIL_TEMPLATEs
                          select e;
            IQueryable<EMAIL_TEMPLATE> mainQueryGridView;
            mainQueryGridView = results.AsQueryable();
            if (includeTemplatesCreatedByAdvancedUsers == false)
            {
                mainQueryGridView = (from e in mainQueryGridView
                                     where e.CREATEDBY_ADVANCED_USER_FLAG == includeTemplatesCreatedByAdvancedUsers
                                     select e);
            }

            _totalCount = mainQueryGridView.Count();

            return mainQueryGridView.SortAndPage(SortExpression, maximumRows, startRowIndex).ToList<EMAIL_TEMPLATE>();
        }

        public IList<EMAIL_TEMPLATE> GetTemplatesForAdvancedUsers(string SortExpression, int maximumRows, int startRowIndex)
        {
            if (string.IsNullOrEmpty(SortExpression))
            {
                SortExpression = templatesDefaultSort;
            }
            maximumRows = maximumRows == 0 ? 10 : maximumRows;

            var results = from list in db.EMAIL_TEMPLATEs
                          where list.ADVANCED_USER_FLAG == true && list.ACTIVE == true
                                && list.CREATEDBY_ADVANCED_USER_FLAG == false
                          select list;
            IQueryable<EMAIL_TEMPLATE> mainQueryGridView;
            mainQueryGridView = results.AsQueryable();
            _totalCountForAdvancedUsers = mainQueryGridView.Count();

            return mainQueryGridView.SortAndPage(SortExpression, maximumRows, startRowIndex).ToList<EMAIL_TEMPLATE>();
        }

        public int GetTemplatesForAdvancedUsersCount()
        {
            return _totalCountForAdvancedUsers;
        }
        /// <summary>
        /// Get the Count of templates
        /// </summary>
        /// <param name="moduleId"></param>
        /// <returns></returns>
        public int GetTemplateCount(bool includeTemplatesCreatedByAdvancedUsers)
        {
            return _totalCount;
        }

        public IList<EMAIL_TEMPLATE> GetTemplatesByUser(string SortExpression, int maximumRows, int startRowIndex, string userName)
        {
            if (string.IsNullOrEmpty(SortExpression))
            {
                SortExpression = templatesDefaultSort;
            }

            maximumRows = maximumRows == 0 ? 10 : maximumRows;

            var results = from list in db.EMAIL_TEMPLATEs
                          where list.ADVANCED_USER_FLAG == true 
                                  && list.CREATEDBY_ADVANCED_USER_FLAG == true
                                  && list.CREATEDBY == userName
                          select list;
            IQueryable<EMAIL_TEMPLATE> mainQueryGridView;
            mainQueryGridView = results.AsQueryable();
            _totalCountByUser = mainQueryGridView.Count();

            return mainQueryGridView.SortAndPage(SortExpression, maximumRows, startRowIndex).ToList<EMAIL_TEMPLATE>();
        }

        public int GetTemplatesByUserCount(string userName)
        {
            return _totalCountByUser;
        }

    }
}

